%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      RealWorldAnalyis.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file performs the analysis of the data collected during
%                 the "Real World" tests.
%-------------------------------------------------------------------------------

vci = imageSet(vci,'colorConversionMethod','MCC Optimized');
vci = imageSet(vci,'colorBalanceMethod','Gray World');% 
vci = imageSet(vci,'internalCS','XYZ');

% First, compute with the default properties.  This uses bilinear
% demosaicing, no color conversion or balancing.  The sensor RGB values are
% simply set to the display RGB values.
vci = vcimageCompute(vci,sensor);
vcAddAndSelectObject(vci);
if (showISET == TRUE),
   vcimageWindow
end

% Extract the image and save it
img = vci.data.result / max(max(max(vci.data.result)));
img(img == NaN) = 0;

figure();
imshow(img);

% End of File
